/*
 * Decompiled with CFR 0.152.
 */
package acm.util;

import acm.util.ErrorException;
import acm.util.JTFTools;
import java.applet.Applet;

public class Animator
extends Thread {
    public static final int INITIAL = 0;
    public static final int RUNNING = 1;
    public static final int STEPPING = 2;
    public static final int CALLING = 3;
    public static final int STOPPING = 4;
    public static final int STOPPED = 5;
    public static final int FINISHED = 6;
    public static final int TERMINATING = 7;
    private static final double SLOW_DELAY = 200.0;
    private static final double FAST_DELAY = 0.0;
    private int animatorState = 0;
    private int currentDepth = 0;
    private int callDepth = 0;
    private int delayCount = 0;
    private double animatorSpeed = 0.5;

    public Animator() {
        this.initAnimator();
    }

    public Animator(ThreadGroup threadGroup) {
        super(threadGroup, (Runnable)null);
        this.initAnimator();
    }

    public Animator(Runnable runnable) {
        super(runnable);
        this.initAnimator();
    }

    public Animator(ThreadGroup threadGroup, Runnable runnable) {
        super(threadGroup, runnable);
        this.initAnimator();
    }

    public void run() {
    }

    public int getAnimatorState() {
        return this.animatorState;
    }

    public void pause(double d) {
        if (this.animatorState == 7) {
            this.terminate();
        }
        JTFTools.pause(d);
    }

    public void startAction() {
        this.start(1);
    }

    public void stopAction() {
        switch (this.animatorState) {
            case 1: 
            case 2: 
            case 3: {
                this.animatorState = 4;
                break;
            }
        }
    }

    public void stepAction() {
        this.start(2);
    }

    public void callAction() {
        this.callDepth = this.currentDepth;
        this.start(3);
    }

    public void setSpeed(double d) {
        this.animatorSpeed = d;
    }

    public double getSpeed() {
        return this.animatorSpeed;
    }

    public void trace() {
        this.trace(0);
    }

    public void trace(int n) {
        this.currentDepth = n;
        switch (this.animatorState) {
            case 1: {
                this.delay();
                break;
            }
            case 2: 
            case 4: {
                this.breakpoint();
                break;
            }
            case 3: {
                if (this.callDepth < this.currentDepth) {
                    this.delay();
                    break;
                }
                this.breakpoint();
                break;
            }
            case 7: {
                this.terminate();
                break;
            }
        }
    }

    public void breakpoint() {
        this.animatorState = 5;
        this.breakHook();
        this.suspendAnimator();
    }

    public void delay() {
        boolean bl = true;
        double d = 0.0;
        if (this.animatorSpeed < 0.9) {
            d = 200.0 + Math.sqrt(this.animatorSpeed / 0.9) * -200.0;
        } else {
            switch ((int)(this.animatorSpeed * 99.99 - 90.0)) {
                case 0: {
                    bl = true;
                    break;
                }
                case 1: {
                    bl = this.delayCount % 10 != 0;
                    break;
                }
                case 2: {
                    bl = this.delayCount % 7 != 0;
                    break;
                }
                case 3: {
                    bl = this.delayCount % 5 != 0;
                    break;
                }
                case 4: {
                    bl = this.delayCount % 3 != 0;
                    break;
                }
                case 5: {
                    bl = this.delayCount % 2 == 0;
                    break;
                }
                case 6: {
                    bl = this.delayCount % 3 == 0;
                    break;
                }
                case 7: {
                    bl = this.delayCount % 4 == 0;
                    break;
                }
                case 8: {
                    bl = this.delayCount % 6 == 0;
                    break;
                }
                case 9: {
                    bl = false;
                    break;
                }
            }
            this.delayCount = (this.delayCount + 1) % 420;
        }
        if (bl) {
            this.delayHook();
            JTFTools.pause(d);
        }
    }

    public void requestTermination() {
        this.animatorState = 7;
    }

    public void checkForTermination() {
        if (this.animatorState == 7) {
            this.terminate();
        } else {
            Thread.yield();
        }
    }

    protected void delayHook() {
    }

    protected void breakHook() {
    }

    protected void resumeHook() {
    }

    protected void controllerHook() {
    }

    public void start() {
        this.start(1);
    }

    private void initAnimator() {
        Applet applet = JTFTools.getApplet();
        if (applet != null) {
            JTFTools.registerApplet(applet, this);
        }
    }

    private void start(int n) {
        switch (this.animatorState) {
            case 0: 
            case 6: {
                this.animatorState = n;
                this.resumeHook();
                this.controllerHook();
                super.start();
                break;
            }
            case 5: {
                this.animatorState = n;
                this.resumeHook();
                this.controllerHook();
                this.resumeAnimator();
                break;
            }
        }
    }

    private void suspendAnimator() {
        Animator animator = this;
        synchronized (animator) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void resumeAnimator() {
        Animator animator = this;
        synchronized (animator) {
            this.notifyAll();
        }
    }

    private void terminate() {
        if (Thread.currentThread() == this) {
            throw new ThreadDeath();
        }
        throw new ErrorException("Illegal call to terminate");
    }
}

